GO 
IF EXISTS(SELECT * FROM INFORMATION_SCHEMA.ROUTINES 
			WHERE ROUTINE_NAME= 'P_PDV_VD_CORRECAO_VALORES'
				AND ROUTINE_TYPE='PROCEDURE')
BEGIN
	DROP PROCEDURE P_PDV_VD_CORRECAO_VALORES
END
GO
--EXEC P_PDV_VD_CORRECAO_VALORES 1, 27, '2018-10-07'
CREATE PROCEDURE P_PDV_VD_CORRECAO_VALORES (@CD_EMP INT, @CD_FILIAL INT, @DT_MOV DATETIME)
AS
SET NOCOUNT ON
CREATE TABLE #RSPDVSEMITENS (CD_EMP INT,
							CD_FILIAL INT,
							CD_VD INT,
							VLR_LIQ_VD MONEY,
							VLR_LIQ_ITENS MONEY,
							VLR_RECEBIMENTO MONEY,
							VLR_CARTAO MONEY,
							TP_CORRECAO INT)
PRINT 'ANALISANDO ITENS CANCELADOS COM VENDA VALIDA'
INSERT INTO #RSPDVSEMITENS
SELECT
	PDV_VD.CD_EMP,
	PDV_VD.CD_FILIAL,
	PDV_VD.CD_VD,
	VLR_LIQ_VD,
	0,
	0,
	0,
	0 AS TP_CORRECAO
FROM
	PDV_VD 
WHERE
	PDV_VD.CD_EMP =@CD_EMP
	AND PDV_VD.CD_FILIAL = @CD_FILIAL
	AND PDV_VD.DT_VD=@DT_MOV
	AND PDV_VD.ST_VD = 0
	AND PDV_VD.CD_USU_CANCEL<>0
UNION ALL
SELECT
	PDV_VD.CD_EMP,
	PDV_VD.CD_FILIAL,
	PDV_VD.CD_VD,
	VLR_LIQ_VD,
	VLR_LIQ_ITENS,
	(ISNULL(PDV_VD.VLR_DINH,0) + PDV_VD.VLR_CHQS + ISNULL(C.VL_CARTAO,0) + VLR_TICKETS + VLR_DUP + VLR_CONV + VLR_CONV_PBM + ISNULL(VLR_NCC,0) - VLR_TROCO_CHQ),
	ISNULL(C.VL_CARTAO,0),
	1 AS TP_CORRECAO
FROM
	PDV_VD LEFT OUTER JOIN 
(SELECT
	CD_EMP,
	CD_FILIAL,
	CD_VD,
	SUM(TOT_IT - VLR_DESC_TOT_RAT) AS VLR_LIQ_ITENS
FROM
	PDV_VD_IT
WHERE
	CD_EMP =@CD_EMP
	AND CD_FILIAL = @CD_FILIAL
	AND DT_VD=@DT_MOV
	AND ST_IT = 1
GROUP BY
	CD_EMP,
	CD_FILIAL,
	CD_VD) RSITENS ON
	PDV_VD.CD_EMP = RSITENS.CD_EMP AND
	PDV_VD.CD_FILIAL = RSITENS.CD_FILIAL AND
	PDV_VD.CD_VD = RSITENS.CD_VD 
    LEFT JOIN (
    SELECT
      PDV_VD_TEF.CD_EMP,
      PDV_VD_TEF.CD_FILIAL,
      PDV_VD_TEF.CD_VD,
      SUM( PDV_VD_TEF.VL_CARTAO ) AS VL_CARTAO
     FROM
       PDV_VD_TEF LEFT OUTER JOIN RC_ADM_CARTAO ON
       PDV_VD_TEF.CD_EMP = RC_ADM_CARTAO.CD_EMP AND
       PDV_VD_TEF.CD_ADM_CARTAO = RC_ADM_CARTAO.CD_ADM_CARTAO
     WHERE
       PDV_VD_TEF.CD_ADM_CARTAO > 0
    GROUP BY
       PDV_VD_TEF.CD_EMP,
       PDV_VD_TEF.CD_FILIAL,
       PDV_VD_TEF.CD_VD) C ON
	PDV_VD.CD_EMP= C.CD_EMP AND
    PDV_VD.CD_FILIAL= C.CD_FILIAL AND
    PDV_VD.CD_VD= C.CD_VD
WHERE
	PDV_VD.CD_EMP =1
	AND PDV_VD.CD_FILIAL = @CD_FILIAL
	AND PDV_VD.DT_VD=@DT_MOV
	AND PDV_VD.ST_VD = 0


PRINT 'CANCELANDO VENDAS'
UPDATE
	PDV_VD
SET
	ST_VD=1,
	DT_ULT_ALT=PDV_VD.DT_VD
FROM
PDV_VD INNER JOIN #RSPDVSEMITENS I ON
PDV_VD.CD_EMP = I.CD_EMP AND
PDV_VD.CD_FILIAL = I.CD_FILIAL AND
PDV_VD.CD_VD = I.CD_VD 
WHERE
TP_CORRECAO=0


PRINT 'CORRIGINDO VALORES DA VENDA'
UPDATE
	PDV_VD
SET
	PDV_VD.VLR_LIQ_VD=VLR_LIQ_ITENS,
	PDV_VD.VLR_VD = VLR_LIQ_ITENS,
	PDV_VD.VLR_DINH = CASE WHEN PDV_VD.VLR_LIQ_VD < I.VLR_RECEBIMENTO  THEN
					0
			   WHEN I.VLR_RECEBIMENTO < PDV_VD.VLR_LIQ_VD THEN
					PDV_VD.VLR_LIQ_VD - I.VLR_RECEBIMENTO
			   ELSE
					ISNULL(VLR_DINH,0)
			   END,
	PDV_VD.VLR_CARTAO = I.VLR_CARTAO
FROM
	PDV_VD INNER JOIN #RSPDVSEMITENS I ON
	PDV_VD.CD_EMP = I.CD_EMP AND
	PDV_VD.CD_FILIAL = I.CD_FILIAL AND
	PDV_VD.CD_VD = I.CD_VD 
WHERE
	TP_CORRECAO=1


--SELECT * FROM #RSPDVSEMITENS WHERE CD_VD = 2857607

DROP TABLE 
#RSPDVSEMITENS

PRINT 'CORRIGINDO STATUS NO PDV_CUPONS COM A PDV_VD'
UPDATE
	PDV_VD_CUPONS
SET 
	ST_VD=PDV_VD.ST_VD
FROM
	PDV_VD INNER JOIN PDV_VD_CUPONS ON
	PDV_VD.CD_EMP = PDV_VD_CUPONS.CD_EMP AND
	PDV_VD.CD_FILIAL = PDV_VD_CUPONS.CD_FILIAL AND
	PDV_VD.NR_ECF = PDV_VD_CUPONS.NR_ECF AND
	PDV_VD.CD_CX = PDV_VD_CUPONS.CD_CX AND
	PDV_VD.DT_VD = PDV_VD_CUPONS.DT_VD  AND
	PDV_VD.ST_VD <> PDV_VD_CUPONS.ST_VD  
WHERE
	PDV_VD_CUPONS.CD_EMP=@CD_EMP
	AND PDV_VD_CUPONS.CD_FILIAL = @CD_FILIAL
	AND PDV_VD_CUPONS.DT_VD =@DT_MOV
